import json
from PIL import Image, ImageDraw, ImageFont
import os


def calculate_font_size(draw, text, max_width, max_height, font_path):
    font_size = 100  
    while font_size > 0:
        font = ImageFont.truetype(font_path, font_size)
        bbox = draw.textbbox((0, 0), text, font=font)
        text_width = bbox[2] - bbox[0]
        text_height = bbox[3] - bbox[1]
        if text_width <= max_width and text_height <= max_height:
            return font
        font_size -= 1
    return ImageFont.truetype(font_path, 1) 


def generate_images(json_path, output_dir, font_path):
    with open(json_path, 'r') as f:
        data = json.load(f)

    os.makedirs(output_dir, exist_ok=True)

    for item in data:
        new_img = Image.new('RGB', (336, 636), 'white')
        draw = ImageDraw.Draw(new_img)


        original_img = Image.open('base_image_path')
        new_img.paste(original_img, (0, 150))

        font_role = calculate_font_size(draw, item['role'], 336-20, 150, font_path)
        bbox = draw.textbbox((0, 0), item['role'], font=font_role)
        x = (336 - (bbox[2] - bbox[0])) // 2
        y = (150 - (bbox[3] - bbox[1])) // 2
        draw.text((x, y), item['role'], font=font_role, fill='black')

        font_keyword = calculate_font_size(draw, item['keyword_instruction'], 336-20, 150, font_path)
        bbox = draw.textbbox((0, 0), item['keyword_instruction'], font=font_keyword)
        x = (336 - (bbox[2] - bbox[0])) // 2
        y = 486 + (150 - (bbox[3] - bbox[1])) // 2
        draw.text((x, y), item['keyword_instruction'], font=font_keyword, fill='black')
        new_img.save(f"{output_dir}/{item['index']}.png")


generate_images(
    json_path='dataset_path',
    output_dir='save_dir', 
    font_path='DejaVuSans.ttf' 
)
